<?php
/**
 * Internationalization: Countries
 *
 * @package SimplePay\Core
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.0.0
 */

namespace SimplePay\Core\i18n;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Returns a list of country codes and countries.
 *
 * @since 3.9.0
 *
 * @return array $countries A list of the available countries
 */
function get_countries() {
	$countries = array(
		'US' => __( 'United States', 'simple-pay' ),
		'CA' => __( 'Canada', 'simple-pay' ),
		'GB' => __( 'United Kingdom', 'simple-pay' ),
		'AD' => __( 'Andorra', 'simple-pay' ),
		'AF' => __( 'Afghanistan', 'simple-pay' ),
		'AX' => __( '&#197;land Islands', 'simple-pay' ),
		'AL' => __( 'Albania', 'simple-pay' ),
		'DZ' => __( 'Algeria', 'simple-pay' ),
		'AS' => __( 'American Samoa', 'simple-pay' ),
		'AD' => __( 'Andorra', 'simple-pay' ),
		'AO' => __( 'Angola', 'simple-pay' ),
		'AI' => __( 'Anguilla', 'simple-pay' ),
		'AQ' => __( 'Antarctica', 'simple-pay' ),
		'AG' => __( 'Antigua and Barbuda', 'simple-pay' ),
		'AR' => __( 'Argentina', 'simple-pay' ),
		'AM' => __( 'Armenia', 'simple-pay' ),
		'AW' => __( 'Aruba', 'simple-pay' ),
		'AU' => __( 'Australia', 'simple-pay' ),
		'AT' => __( 'Austria', 'simple-pay' ),
		'AZ' => __( 'Azerbaijan', 'simple-pay' ),
		'BS' => __( 'Bahamas', 'simple-pay' ),
		'BH' => __( 'Bahrain', 'simple-pay' ),
		'BD' => __( 'Bangladesh', 'simple-pay' ),
		'BB' => __( 'Barbados', 'simple-pay' ),
		'BY' => __( 'Belarus', 'simple-pay' ),
		'BE' => __( 'Belgium', 'simple-pay' ),
		'BZ' => __( 'Belize', 'simple-pay' ),
		'BJ' => __( 'Benin', 'simple-pay' ),
		'BM' => __( 'Bermuda', 'simple-pay' ),
		'BT' => __( 'Bhutan', 'simple-pay' ),
		'BO' => __( 'Bolivia', 'simple-pay' ),
		'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'simple-pay' ),
		'BA' => __( 'Bosnia and Herzegovina', 'simple-pay' ),
		'BW' => __( 'Botswana', 'simple-pay' ),
		'BV' => __( 'Bouvet Island', 'simple-pay' ),
		'BR' => __( 'Brazil', 'simple-pay' ),
		'IO' => __( 'British Indian Ocean Territory', 'simple-pay' ),
		'BN' => __( 'Brunei Darrussalam', 'simple-pay' ),
		'BG' => __( 'Bulgaria', 'simple-pay' ),
		'BF' => __( 'Burkina Faso', 'simple-pay' ),
		'BI' => __( 'Burundi', 'simple-pay' ),
		'KH' => __( 'Cambodia', 'simple-pay' ),
		'CM' => __( 'Cameroon', 'simple-pay' ),
		'CV' => __( 'Cape Verde', 'simple-pay' ),
		'KY' => __( 'Cayman Islands', 'simple-pay' ),
		'CF' => __( 'Central African Republic', 'simple-pay' ),
		'TD' => __( 'Chad', 'simple-pay' ),
		'CL' => __( 'Chile', 'simple-pay' ),
		'CN' => __( 'China', 'simple-pay' ),
		'CX' => __( 'Christmas Island', 'simple-pay' ),
		'CC' => __( 'Cocos Islands', 'simple-pay' ),
		'CO' => __( 'Colombia', 'simple-pay' ),
		'KM' => __( 'Comoros', 'simple-pay' ),
		'CD' => __( 'Congo, Democratic People\'s Republic', 'simple-pay' ),
		'CG' => __( 'Congo, Republic of', 'simple-pay' ),
		'CK' => __( 'Cook Islands', 'simple-pay' ),
		'CR' => __( 'Costa Rica', 'simple-pay' ),
		'CI' => __( 'Cote d\'Ivoire', 'simple-pay' ),
		'HR' => __( 'Croatia/Hrvatska', 'simple-pay' ),
		'CU' => __( 'Cuba', 'simple-pay' ),
		'CW' => __( 'Cura&Ccedil;ao', 'simple-pay' ),
		'CY' => __( 'Cyprus', 'simple-pay' ),
		'CZ' => __( 'Czech Republic', 'simple-pay' ),
		'DK' => __( 'Denmark', 'simple-pay' ),
		'DJ' => __( 'Djibouti', 'simple-pay' ),
		'DM' => __( 'Dominica', 'simple-pay' ),
		'DO' => __( 'Dominican Republic', 'simple-pay' ),
		'TP' => __( 'East Timor', 'simple-pay' ),
		'EC' => __( 'Ecuador', 'simple-pay' ),
		'EG' => __( 'Egypt', 'simple-pay' ),
		'GQ' => __( 'Equatorial Guinea', 'simple-pay' ),
		'SV' => __( 'El Salvador', 'simple-pay' ),
		'ER' => __( 'Eritrea', 'simple-pay' ),
		'EE' => __( 'Estonia', 'simple-pay' ),
		'ET' => __( 'Ethiopia', 'simple-pay' ),
		'FK' => __( 'Falkland Islands', 'simple-pay' ),
		'FO' => __( 'Faroe Islands', 'simple-pay' ),
		'FJ' => __( 'Fiji', 'simple-pay' ),
		'FI' => __( 'Finland', 'simple-pay' ),
		'FR' => __( 'France', 'simple-pay' ),
		'GF' => __( 'French Guiana', 'simple-pay' ),
		'PF' => __( 'French Polynesia', 'simple-pay' ),
		'TF' => __( 'French Southern Territories', 'simple-pay' ),
		'GA' => __( 'Gabon', 'simple-pay' ),
		'GM' => __( 'Gambia', 'simple-pay' ),
		'GE' => __( 'Georgia', 'simple-pay' ),
		'DE' => __( 'Germany', 'simple-pay' ),
		'GR' => __( 'Greece', 'simple-pay' ),
		'GH' => __( 'Ghana', 'simple-pay' ),
		'GI' => __( 'Gibraltar', 'simple-pay' ),
		'GL' => __( 'Greenland', 'simple-pay' ),
		'GD' => __( 'Grenada', 'simple-pay' ),
		'GP' => __( 'Guadeloupe', 'simple-pay' ),
		'GU' => __( 'Guam', 'simple-pay' ),
		'GT' => __( 'Guatemala', 'simple-pay' ),
		'GG' => __( 'Guernsey', 'simple-pay' ),
		'GN' => __( 'Guinea', 'simple-pay' ),
		'GW' => __( 'Guinea-Bissau', 'simple-pay' ),
		'GY' => __( 'Guyana', 'simple-pay' ),
		'HT' => __( 'Haiti', 'simple-pay' ),
		'HM' => __( 'Heard and McDonald Islands', 'simple-pay' ),
		'VA' => __( 'Holy See (City Vatican State)', 'simple-pay' ),
		'HN' => __( 'Honduras', 'simple-pay' ),
		'HK' => __( 'Hong Kong', 'simple-pay' ),
		'HU' => __( 'Hungary', 'simple-pay' ),
		'IS' => __( 'Iceland', 'simple-pay' ),
		'IN' => __( 'India', 'simple-pay' ),
		'ID' => __( 'Indonesia', 'simple-pay' ),
		'IR' => __( 'Iran', 'simple-pay' ),
		'IQ' => __( 'Iraq', 'simple-pay' ),
		'IE' => __( 'Ireland', 'simple-pay' ),
		'IM' => __( 'Isle of Man', 'simple-pay' ),
		'IL' => __( 'Israel', 'simple-pay' ),
		'IT' => __( 'Italy', 'simple-pay' ),
		'JM' => __( 'Jamaica', 'simple-pay' ),
		'JP' => __( 'Japan', 'simple-pay' ),
		'JE' => __( 'Jersey', 'simple-pay' ),
		'JO' => __( 'Jordan', 'simple-pay' ),
		'KZ' => __( 'Kazakhstan', 'simple-pay' ),
		'KE' => __( 'Kenya', 'simple-pay' ),
		'KI' => __( 'Kiribati', 'simple-pay' ),
		'KW' => __( 'Kuwait', 'simple-pay' ),
		'KG' => __( 'Kyrgyzstan', 'simple-pay' ),
		'LA' => __( 'Lao People\'s Democratic Republic', 'simple-pay' ),
		'LV' => __( 'Latvia', 'simple-pay' ),
		'LB' => __( 'Lebanon', 'simple-pay' ),
		'LS' => __( 'Lesotho', 'simple-pay' ),
		'LR' => __( 'Liberia', 'simple-pay' ),
		'LY' => __( 'Libyan Arab Jamahiriya', 'simple-pay' ),
		'LI' => __( 'Liechtenstein', 'simple-pay' ),
		'LT' => __( 'Lithuania', 'simple-pay' ),
		'LU' => __( 'Luxembourg', 'simple-pay' ),
		'MO' => __( 'Macau', 'simple-pay' ),
		'MK' => __( 'Macedonia', 'simple-pay' ),
		'MG' => __( 'Madagascar', 'simple-pay' ),
		'MW' => __( 'Malawi', 'simple-pay' ),
		'MY' => __( 'Malaysia', 'simple-pay' ),
		'MV' => __( 'Maldives', 'simple-pay' ),
		'ML' => __( 'Mali', 'simple-pay' ),
		'MT' => __( 'Malta', 'simple-pay' ),
		'MH' => __( 'Marshall Islands', 'simple-pay' ),
		'MQ' => __( 'Martinique', 'simple-pay' ),
		'MR' => __( 'Mauritania', 'simple-pay' ),
		'MU' => __( 'Mauritius', 'simple-pay' ),
		'YT' => __( 'Mayotte', 'simple-pay' ),
		'MX' => __( 'Mexico', 'simple-pay' ),
		'FM' => __( 'Micronesia', 'simple-pay' ),
		'MD' => __( 'Moldova, Republic of', 'simple-pay' ),
		'MC' => __( 'Monaco', 'simple-pay' ),
		'MN' => __( 'Mongolia', 'simple-pay' ),
		'ME' => __( 'Montenegro', 'simple-pay' ),
		'MS' => __( 'Montserrat', 'simple-pay' ),
		'MA' => __( 'Morocco', 'simple-pay' ),
		'MZ' => __( 'Mozambique', 'simple-pay' ),
		'MM' => __( 'Myanmar', 'simple-pay' ),
		'NA' => __( 'Namibia', 'simple-pay' ),
		'NR' => __( 'Nauru', 'simple-pay' ),
		'NP' => __( 'Nepal', 'simple-pay' ),
		'NL' => __( 'Netherlands', 'simple-pay' ),
		'AN' => __( 'Netherlands Antilles', 'simple-pay' ),
		'NC' => __( 'New Caledonia', 'simple-pay' ),
		'NZ' => __( 'New Zealand', 'simple-pay' ),
		'NI' => __( 'Nicaragua', 'simple-pay' ),
		'NE' => __( 'Niger', 'simple-pay' ),
		'NG' => __( 'Nigeria', 'simple-pay' ),
		'NU' => __( 'Niue', 'simple-pay' ),
		'NF' => __( 'Norfolk Island', 'simple-pay' ),
		'KP' => __( 'North Korea', 'simple-pay' ),
		'MP' => __( 'Northern Mariana Islands', 'simple-pay' ),
		'NO' => __( 'Norway', 'simple-pay' ),
		'OM' => __( 'Oman', 'simple-pay' ),
		'PK' => __( 'Pakistan', 'simple-pay' ),
		'PW' => __( 'Palau', 'simple-pay' ),
		'PS' => __( 'Palestinian Territories', 'simple-pay' ),
		'PA' => __( 'Panama', 'simple-pay' ),
		'PG' => __( 'Papua New Guinea', 'simple-pay' ),
		'PY' => __( 'Paraguay', 'simple-pay' ),
		'PE' => __( 'Peru', 'simple-pay' ),
		'PH' => __( 'Philippines', 'simple-pay' ),
		'PN' => __( 'Pitcairn Island', 'simple-pay' ),
		'PL' => __( 'Poland', 'simple-pay' ),
		'PT' => __( 'Portugal', 'simple-pay' ),
		'PR' => __( 'Puerto Rico', 'simple-pay' ),
		'QA' => __( 'Qatar', 'simple-pay' ),
		'XK' => __( 'Republic of Kosovo', 'simple-pay' ),
		'RE' => __( 'Reunion Island', 'simple-pay' ),
		'RO' => __( 'Romania', 'simple-pay' ),
		'RU' => __( 'Russian Federation', 'simple-pay' ),
		'RW' => __( 'Rwanda', 'simple-pay' ),
		'BL' => __( 'Saint Barth&eacute;lemy', 'simple-pay' ),
		'SH' => __( 'Saint Helena', 'simple-pay' ),
		'KN' => __( 'Saint Kitts and Nevis', 'simple-pay' ),
		'LC' => __( 'Saint Lucia', 'simple-pay' ),
		'MF' => __( 'Saint Martin (French)', 'simple-pay' ),
		'SX' => __( 'Saint Martin (Dutch)', 'simple-pay' ),
		'PM' => __( 'Saint Pierre and Miquelon', 'simple-pay' ),
		'VC' => __( 'Saint Vincent and the Grenadines', 'simple-pay' ),
		'SM' => __( 'San Marino', 'simple-pay' ),
		'ST' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'simple-pay' ),
		'SA' => __( 'Saudi Arabia', 'simple-pay' ),
		'SN' => __( 'Senegal', 'simple-pay' ),
		'RS' => __( 'Serbia', 'simple-pay' ),
		'SC' => __( 'Seychelles', 'simple-pay' ),
		'SL' => __( 'Sierra Leone', 'simple-pay' ),
		'SG' => __( 'Singapore', 'simple-pay' ),
		'SK' => __( 'Slovakia', 'simple-pay' ),
		'SI' => __( 'Slovenia', 'simple-pay' ),
		'SB' => __( 'Solomon Islands', 'simple-pay' ),
		'SO' => __( 'Somalia', 'simple-pay' ),
		'ZA' => __( 'South Africa', 'simple-pay' ),
		'GS' => __( 'South Georgia', 'simple-pay' ),
		'KR' => __( 'South Korea', 'simple-pay' ),
		'SS' => __( 'South Sudan', 'simple-pay' ),
		'ES' => __( 'Spain', 'simple-pay' ),
		'LK' => __( 'Sri Lanka', 'simple-pay' ),
		'SD' => __( 'Sudan', 'simple-pay' ),
		'SR' => __( 'Suriname', 'simple-pay' ),
		'SJ' => __( 'Svalbard and Jan Mayen Islands', 'simple-pay' ),
		'SZ' => __( 'Swaziland', 'simple-pay' ),
		'SE' => __( 'Sweden', 'simple-pay' ),
		'CH' => __( 'Switzerland', 'simple-pay' ),
		'SY' => __( 'Syrian Arab Republic', 'simple-pay' ),
		'TA' => __( 'Tajikistan', 'simple-pay' ),
		'TW' => __( 'Taiwan', 'simple-pay' ),
		'TJ' => __( 'Tajikistan', 'simple-pay' ),
		'TZ' => __( 'Tanzania', 'simple-pay' ),
		'TH' => __( 'Thailand', 'simple-pay' ),
		'TL' => __( 'Timor-Leste', 'simple-pay' ),
		'TG' => __( 'Togo', 'simple-pay' ),
		'TK' => __( 'Tokelau', 'simple-pay' ),
		'TO' => __( 'Tonga', 'simple-pay' ),
		'TT' => __( 'Trinidad and Tobago', 'simple-pay' ),
		'TN' => __( 'Tunisia', 'simple-pay' ),
		'TR' => __( 'Turkey', 'simple-pay' ),
		'TM' => __( 'Turkmenistan', 'simple-pay' ),
		'TC' => __( 'Turks and Caicos Islands', 'simple-pay' ),
		'TV' => __( 'Tuvalu', 'simple-pay' ),
		'UG' => __( 'Uganda', 'simple-pay' ),
		'UA' => __( 'Ukraine', 'simple-pay' ),
		'AE' => __( 'United Arab Emirates', 'simple-pay' ),
		'UY' => __( 'Uruguay', 'simple-pay' ),
		'UM' => __( 'US Minor Outlying Islands', 'simple-pay' ),
		'UZ' => __( 'Uzbekistan', 'simple-pay' ),
		'VU' => __( 'Vanuatu', 'simple-pay' ),
		'VE' => __( 'Venezuela', 'simple-pay' ),
		'VN' => __( 'Vietnam', 'simple-pay' ),
		'VG' => __( 'Virgin Islands (British)', 'simple-pay' ),
		'VI' => __( 'Virgin Islands (USA)', 'simple-pay' ),
		'WF' => __( 'Wallis and Futuna Islands', 'simple-pay' ),
		'EH' => __( 'Western Sahara', 'simple-pay' ),
		'WS' => __( 'Western Samoa', 'simple-pay' ),
		'YE' => __( 'Yemen', 'simple-pay' ),
		'ZM' => __( 'Zambia', 'simple-pay' ),
		'ZW' => __( 'Zimbabwe', 'simple-pay' ),
	);

	return apply_filters( 'simpay_countries', $countries );
}
