<?php
/**
 * Simple Pay: Meta
 *
 * @package SimplePay\Core\Post_Types\Simple_Pay\Meta
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.8.0
 */

namespace SimplePay\Core\Post_Types\Simple_Pay\Meta;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Registers `simple-pay` meta fields to store Payment Form settings.
 *
 * @since 3.8.0
 */
function register() {
	// Amount.
	register_post_meta(
		'simple-pay',
		'_amount',
		array(
			'type'              => 'string',
			'description'       => __( 'Payment Form amount.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	// Success redirect type.
	register_post_meta(
		'simple-pay',
		'_success_redirect_type',
		array(
			'type'              => 'string',
			'description'       => __( 'Payment Form success redirect type.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	// Success redirect page.
	register_post_meta(
		'simple-pay',
		'_success_redirect_page',
		array(
			'type'              => 'string',
			'description'       => __( 'Payment Form success page redirect page.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => 'absint',
		)
	);

	// Success redirect URL.
	register_post_meta(
		'simple-pay',
		'_success_redirect_url',
		array(
			'type'              => 'string',
			'description'       => __( 'Payment Form success page redirect URL.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => 'esc_url',
		)
	);

	// Company name.
	register_post_meta(
		'simple-pay',
		'_company_name',
		array(
			'type'              => 'string',
			'description'       => __( 'Payment Form Company Name.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	// Item description.
	register_post_meta(
		'simple-pay',
		'_item_description',
		array(
			'type'              => 'string',
			'description'       => __( 'Payment Form Item Description.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	// Stripe Checkout - Image URL.
	register_post_meta(
		'simple-pay',
		'_image_url',
		array(
			'type'              => 'string',
			'description'       => __( 'Payment Form image URL.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => 'esc_url',
		)
	);

	// Stripe Checkout - Submit button type.
	register_post_meta(
		'simple-pay',
		'_checkout_submit_type',
		array(
			'type'              => 'string',
			'description'       => __( 'Payment Form Stripe Checkout submit button type.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	// Stripe Checkout - Enable Billing Address
	register_post_meta(
		'simple-pay',
		'_enable_billing_address',
		array(
			'type'              => 'string',
			'description'       => __( 'Payment Form Stripe Checkout billing address.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	// Stripe Checkout - Enable Shipping Address
	register_post_meta(
		'simple-pay',
		'_enable_shipping_address',
		array(
			'type'              => 'string',
			'description'       => __( 'Payment Form Stripe Checkout shipping address.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	// Stripe Checkout - Payment button style.
	register_post_meta(
		'simple-pay',
		'_payment_button_style',
		array(
			'type'              => 'boolean',
			'description'       => __( 'Payment Form Stripe Checkout payment button styles.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => null,
		)
	);

	// Custom fields.
	register_post_meta(
		'simple-pay',
		'_custom_fields',
		array(
			'type'              => 'array',
			'description'       => __( 'Payment Form custom fields.', 'simple-pay' ),
			'single'            => true,
			'sanitize_callback' => null,
		)
	);
}
add_action( 'init', __NAMESPACE__ . '\\register', 20 );
