<?php
/**
 *
 * @global WP_Post $post
 *
 * @var array  $payment_methods             List of enabled Payment Methods and configuration.
 * @var array  $available_payment_methods   List of available Payment Methods.
 * @var array  $payment_methods_with_config List of Payment Methods that require additional configuration.
 * @var string $context                     Payment Methods context. Default `stripe-elements`
 */

namespace SimplePay\Pro\Admin\Metaboxes\Views\Partials;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post;

$subscription_type = simpay_get_saved_meta( $post->ID, '_subscription_type', 'disabled' );

// Allow filtered currency to prevent force-disabling Payment Methods
// that are actually available with the currency that will be on the frontend.
$currency = simpay_get_filtered( 'currency', simpay_get_global_setting( 'currency' ), $post->ID );
?>

<tr class="simpay-panel-field">
	<th>
		<strong>
			<?php esc_html_e( 'Payment Methods', 'simple-pay' ); ?>
		</strong>
	</th>
	<td>
		<?php
		foreach ( $available_payment_methods as $payment_method ) :
			$disabled = (
				// Generally not available.
				true !== $payment_method->is_available() ||

				// Subscriptions are enabled and Payment Method does not support it.
				'disabled' !== $subscription_type && false === $payment_method->recurring
			);

			$checked = (
				! $disabled &&
				isset( $payment_methods[ $payment_method->id ], $payment_methods[ $payment_method->id ]['id'] )
			);
			?>
			<div class="simpay-panel-field--payment-method">
				<label for="<?php echo esc_attr( 'simpay-payment-method-' . $payment_method->id ); ?>-<?php echo esc_attr( $context ); ?>">
					<span class="simpay-field-bool">
						<input
							name="_simpay_payment_methods[<?php echo esc_attr( $context ); ?>][<?php echo esc_attr( $payment_method->id ); ?>][id]"
							type="checkbox"
							value="<?php echo esc_attr( $payment_method->id ); ?>"
							id="simpay-payment-method-<?php echo esc_attr( $payment_method->id ); ?>-<?php echo esc_attr( $context ); ?>"
							class="simpay-field simpay-field-checkbox simpay-field simpay-field-checkboxes simpay-payment-method"
							<?php checked( true, $checked ); ?>
							<?php disabled( true, $disabled ); ?>
							<?php if ( false === $payment_method->is_available() ) : ?>
								data-disabled
							<?php endif; ?>
							<?php if ( true === $payment_method->recurring ) : ?>
								data-recurring
							<?php endif; ?>
						>
						<?php echo esc_html( $payment_method->name ); ?>
					</span>

					<?php if ( false === $payment_method->is_currency_supported( $currency ) ) : ?>
					<p class="description" style="margin-top: 4px;">
						<?php
						echo esc_html(
							sprintf(
								/** translators: %s Currency code. */
								__( '%s is not a supported currency.', 'simple-pay' ),
								strtoupper( $currency )
							)
						);
						?>
					</p>
					<?php endif; ?>

					<?php
					if ( false === $payment_method->recurring ) :
						$classnames = array_keys(
							array_filter(
								array(
									'simpay-payment-method-no-recurring' => true,
									'description'    => true,
									'simpay-show-if' => ( false === $payment_method->recurring ),
								)
							)
						);
						?>
					<p class="<?php echo esc_attr( implode( ' ', $classnames ) ); ?>" data-if="_subscription_type" data-is="single user" style="margin-top: 4px;">
						<?php esc_html_e( 'Subscriptions are not supported.', 'simple-pay' ); ?>
					</p>
					<?php endif; ?>
				</label>

				<?php if ( in_array( $payment_method->id, $payment_methods_with_config, true ) ) : ?>
				<button
					data-payment-method="<?php echo esc_attr( $payment_method->id ); ?>"
					class="payment-method-configure button button-secondary button-small simpay-panel-field--payment-method__configure"
				>
					<?php esc_html_e( 'Configure', 'simple-pay' ); ?>
				</button>
				<?php endif; ?>

				<?php if ( ! empty( $payment_method->external_docs ) ) : ?>
				<a
					href="<?php echo esc_url( $payment_method->external_docs ); ?>"
					class="simpay-panel-field--payment-method__help"
					target="_blank"
					rel="noopener noreferrer"
				>
					<span class="dashicons dashicons-editor-help"></span>
					<span class="screen-reader-text"><?php esc_html_e( 'Learn about Payment Method', 'simple-pay' ); ?></span>
				</a>
				<?php endif; ?>
			</div>
		<?php endforeach; ?>

		<div class="notice inline notice-info">
			<p>
				<?php
				echo wp_kses(
					sprintf(
						__( 'Some Payment Methods must also be enabled in %1$sStripe Payment Method settings%2$s.', 'simple-pay' ),
						'<a href="https://dashboard.stripe.com/settings/payments" target="_blank" rel="noopener noreferrer">',
						'</a>'
					),
					array(
						'a' => array(
							'href'   => true,
							'target' => true,
							'rel'    => true,
						),
					)
				);
				?>
			</p>
		</div>
	</td>
</tr>
