/* global jQuery */

let spSubAdmin = {};

( function( $ ) {
	'use strict';

	let body,
		spSubSettings;

	spSubAdmin = {

		init() {
			// We need to initialize these here because that's when the document is finally ready
			body = $( document.body );
			spSubSettings = body.find( '#subscription-options-settings-panel' );

			this.loadMultiPlanSubscriptions();

			// Initialize sortable fields for multi-plans
			this.initSortablePlans( spSubSettings.find( '#simpay-user-sub-wrap .simpay-metaboxes' ) );

			// Add plan button
			spSubSettings.find( '.simpay-add-plan' ).on( 'click.simpayAddPlan', function( e ) {
				e.preventDefault();

				spSubAdmin.addPlan( e );
			} );

			// Remove Plan action
			spSubSettings.find( '.simpay-panel-field' ).on( 'click.simpayRemovePlan', '.simpay-remove-plan', function( e ) {
				spSubAdmin.removePlan( $( this ), e );
			} );

			// Update default subscription
			spSubSettings.on( 'change', 'input[name="_multi_plan_default_value"]', function( e ) {
				spSubAdmin.updateDefaultPlan( $( this ) );
			} );

			// Enable/Disable single subscription plan dropdown
			spSubSettings.find( '#_subscription_custom_amount' ).find( 'input[type="radio"]' ).on( 'change.simpayToggleSubscription', function( e ) {
				spSubAdmin.togglePlans( $( this ) );
			} );
		},

		initSortablePlans( el ) {
			el.sortable( {
				items: '.simpay-field-metabox',
				containment: '#simpay-form-settings',
				handle: '.simpay-hndle',
				placeholder: 'sortable-placeholder',
				cursor: 'move',
				delay: ( $( document.body ).hasClass( 'mobile' ) ? 200 : 0 ),
				distance: 2,
				tolerance: 'pointer',
				forcePlaceholderSize: true,
				opacity: 0.65,
				stop( e, ui ) {
					spSubAdmin.orderPlans();
				},

				// @link https://core.trac.wordpress.org/changeset/35809
				helper( event, element ) {
					/* `helper: 'clone'` is equivalent to `return element.clone();`
					 * Cloning a checked radio and then inserting that clone next to the original
					 * radio unchecks the original radio (since only one of the two can be checked).
					 * We get around this by renaming the helper's inputs' name attributes so that,
					 * when the helper is inserted into the DOM for the sortable, no radios are
					 * duplicated, and no original radio gets unchecked.
					 */
					return element.clone()
						.find( ':input' )
						.attr( 'name', function( i, currentName ) {
							return 'sort_' + parseInt( Math.random() * 100000, 10 ).toString() + '_' + currentName;
						} )
						.end();
				},
			} );
		},

		loadMultiPlanSubscriptions() {
			const simpayPlans = spSubSettings.find( '.simpay-multi-sub' ).get();

			simpayPlans.sort( function( a, b ) {
				const compA = parseInt( $( a ).attr( 'rel' ), 10 );
				const compB = parseInt( $( b ).attr( 'rel' ), 10 );
				return ( compA < compB ) ? -1 : ( compA > compB ) ? 1 : 0;
			} );

			spSubSettings.find( simpayPlans ).each( function( idx, itm ) {
				spSubSettings.find( '.simpay-multi-subscriptions tbody' ).append( itm );
			} );
		},

		togglePlans( el ) {
			// TODO DRY

			if ( 'enabled' === el.val() && el.is( ':checked' ) ) {
				body.find( '#_single_plan' ).prop( 'disabled', true ).trigger( 'chosen:updated' );
			} else {
				body.find( '#_single_plan' ).prop( 'disabled', false ).trigger( 'chosen:updated' );
			}
		},

		updateDefaultPlan( el ) {
			$( 'input[name="_multi_plan_default_value"]' ).prop( 'checked', false );
			el.prop( 'checked', true );
		},

		orderPlans() {
			spSubSettings.find( '.simpay-multi-sub' ).each( function( index, el ) {
				const planIndex = parseInt( $( el ).index( '.simpay-multi-sub' ) );

				spSubSettings.find( '.plan-order', el ).val( planIndex );
			} );
		},

		addPlan( e ) {
			const wrapper = spSubSettings.find( '#simpay-user-sub-wrap .simpay-metaboxes' );
			const currentKey = wrapper.find( '.simpay-field-metabox' ).length;

			const data = {
				action: 'simpay_add_plan',
				counter: parseInt( currentKey ),
				plan: $( '#simpay-user-sub-add-plan' ).val(),
				addPlanNonce: body.find( '#simpay_add_plan_nonce' ).val(),
				postId: $( '#post_ID' ).val(),
			};

			e.preventDefault();

			$.ajax( {
				url: ajaxurl,
				method: 'POST',
				data,
				success( response ) {
					wrapper.append( response );
				},
				error( response ) {
					spShared.debugLog( response );
				},
			} )
				.done( ( response ) => {
					const isEmpty = 0 <= currentKey;

					$( '.simpay-user-subs' ).toggleClass( 'is-empty', ! isEmpty );
					$( '.simpay-user-subs .simpay-metaboxes' ).toggleClass( 'is-empty', ! isEmpty );

					$( '#simpay-user-sub-add-plan' ).val( 'empty' );
				} )
		},

		removePlan( el, e ) {
			e.preventDefault();

			el.closest( '.simpay-field-metabox' ).remove();

			const wrapper = spSubSettings.find( '#simpay-user-sub-wrap .simpay-metaboxes' );
			const count = wrapper.find( '.simpay-field-metabox' ).length;
			const isEmpty = 0 === count;

			$( '.simpay-user-subs' ).toggleClass( 'is-empty', isEmpty );
			$( '.simpay-user-subs .simpay-metaboxes' ).toggleClass( 'is-empty', isEmpty );
		},
	};

	$( document ).ready( function( $ ) {
		spSubAdmin.init();
	} );
}( jQuery ) );
