/**
 * Internal dependencies.
 */

import { onPaymentFormError } from '@wpsimplepay/core/frontend/payment-forms';
import { getOwnerData } from './utils.js';
import { handle as handleSource } from '@wpsimplepay/pro/frontend/payments/source.js';

/**
 * Submit `card` Payment Method.
 *
 * @param {jQuery} spFormElem Form element jQuery object.
 * @param {Object} formData Configured form data.
 */
export async function submit( spFormElem, formData ) {
	const {
		stripeInstance: stripe,
		stripeInstance: { elements },
	} = spFormElem;

	// Create a Source.
	const { currency } = formData;
	const owner = getOwnerData( spFormElem, formData );

	const { error, source } = await stripe.createSource( elements.card, {
		type: 'card',
		currency,
		owner,
	} );

	try {
		// Bail if Source cannot be created.
		if ( error ) {
			throw error;
		}

		// Create records with Source.
		handleSource( source, spFormElem, formData );
	} catch ( error ) {
		onPaymentFormError( error, spFormElem, formData );
	}
}
