/**
 * Find card owner data in the form.
 *
 * @param {jQuery} spFormElem Form element jQuery object.
 * @param {Object} formData Configured form data.
 */
export function getOwnerData( spFormElem, formData ) {
	const billingAddressContainer = spFormElem.find(
		'.simpay-billing-address-container'
	);

	const name = spFormElem.find( '.simpay-customer-name' ).val() || null;
	const email = spFormElem.find( '.simpay-email' ).val() || null;
	const phone = spFormElem.find( '.simpay-telephone' ).val() || null;
	const address =
		0 !== billingAddressContainer.length
			? {
					line1:
						billingAddressContainer
							.find( '.simpay-address-street' )
							.val() || null,
					city:
						billingAddressContainer
							.find( '.simpay-address-city' )
							.val() || null,
					state:
						billingAddressContainer
							.find( '.simpay-address-state' )
							.val() || null,
					postal_code:
						billingAddressContainer
							.find( '.simpay-address-zip' )
							.val() || null,
					country:
						billingAddressContainer
							.find( '.simpay-address-country' )
							.val() || null,
			  }
			: null;

	return {
		name,
		email,
		phone,
		address,
	};
}
