<?php
/**
 * ACH Debit: Functions
 *
 * @package SimplePay\Core\Payment_Methods\ACH_Debit
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.9.0
 */

namespace SimplePay\Pro\Payment_Methods\ACH_Debit;
use SimplePay\Core\Utils;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Enqueues extra scripts for ACH Debit (via Plaid).
 *
 * Using wp_enqueue_script causes an error with link-initiliaze.js
 *
 * @since 3.9.0
 *
 * @param \SimplePay\Pro\Payment_Methods\Payment_Method[] $payment_methods Payment Methods.
 */
function enqueue( $payment_methods ) {
	if ( isset( $payment_methods['ach-debit'] ) ) {
		echo '<script src="https://cdn.plaid.com/link/v2/stable/link-initialize.js"></script>';
	}

	// Prevent this from running more than once on a page.
	remove_action( 'simpay_payment_form_payment_methods_before', __NAMESPACE__ . '\\enqueue'  );
}
add_action( 'simpay_payment_form_payment_methods_before', __NAMESPACE__ . '\\enqueue' );
