<?php
/**
 * Card: Payment confirmation
 *
 * @package SimplePay\Pro\Payments\Payment_Methods\Card
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.9.0
 */

namespace SimplePay\Pro\Payments\Payment_Methods\Card;

/**
 * Filters the content to be shown before the "Update Payment Method" form.
 *
 * @since 3.9.0
 *
 * @param string                               $message          Update Payment Method message.
 * @param \Stripe\PaymentMethod|\Stripe\Source $payment_method   Payment Method or Source.
 * @param \Stripe\Subscription                 $subscription     Subscription.
 * @param \Stripe\Invoice                      $upcoming_invoice Upcoming invoice.
 * @return string
 */
function update_payment_method_message( $message, $payment_method, $subscription, $upcoming_invoice ) {
	if ( ! isset( $payment_method->card ) ) {
		return $message;
	}

	$amount_due = $upcoming_invoice->amount_due;
	$currency   = $upcoming_invoice->currency;

	$amount_due = html_entity_decode(
		simpay_format_currency( simpay_convert_amount_to_dollars( $amount_due ), $currency )
	);

	return wpautop(
		wp_kses(
			sprintf(
				__( 'The next invoice for %1$s will automatically charge %2$s &bull;&bull;&bull;&bull; %3$s on %4$s.', 'simple-pay' ),
				$amount_due,
				'<strong>' . ucwords( $payment_method->card->brand ) . '</strong>',
				'<strong>' . $payment_method->card->last4 . '</strong>',
				date_i18n(
					get_option( 'date_format' ),
					$subscription->current_period_end
				)
			),
			array(
				'strong' => true,
			)
		)
	);
}
add_filter( 'simpay_update_payment_method_message', __NAMESPACE__ . '\\update_payment_method_message', 10, 4 );
