<?php
/**
 * iDEAL: Payment confirmation
 *
 * @package SimplePay\Pro\Payments\Payment_Methods\iDEAL
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.8.0
 */

namespace SimplePay\Pro\Payments\Payment_Methods\iDEAL;

use SimplePay\Core\Payments\Customer;
use SimplePay\Core\Payments\Payment_Confirmation;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Validates the Payment Confirmation data.
 *
 * If the data includes an invalid or incomplete PaymentIntent
 * redirect to the form's failure page.
 *
 * @since 3.8.0
 */
function validate_payment_confirmation_data() {
	// Ensure we can retrieve a PaymentIntent.
	if ( ! isset( $_GET['payment_intent'] ) ) {
		return;
	}

	// Ensure we paid with iDEAL.
	if ( ! isset( $_GET['source_type'] ) || 'ideal' !== $_GET['source_type'] ) {
		return;
	}

	// Ensure we customer so `Payment_Confirmation\get_confirmation_data()` doesn't fail.
	if ( ! isset( $_GET['customer_id'] ) ) {
		return;
	}

	$payment_confirmation_data = Payment_Confirmation\get_confirmation_data();
	$payment_intent            = isset( $payment_confirmation_data['paymentintents'] )
		? current( $payment_confirmation_data['paymentintents'] )
		: false;

	$failure_page = $payment_confirmation_data['form']->payment_cancelled_page;

	// Redirect to failure if PaymentIntent cannot be found.
	if ( false === $payment_intent ) {
		wp_safe_redirect( $failure_page );
	}

	// Remove Customer record and redirect to failure if PaymentIntent has not succeeded.
	if ( 'succeeded' !== $payment_intent->status ) {
		// Delete the generated Customer record.
		try {
			Customer\delete( $payment_confirmation_data['customer']->id );
		} catch ( \Exception $e ) {
			// Do nothing if we cannot delete the generated record.
		}

		wp_safe_redirect( $failure_page );
	}
}
add_action( 'template_redirect', __NAMESPACE__ . '\\validate_payment_confirmation_data' );
