<?php
/**
 * Payments: Product
 *
 * @package SimplePay\Pro\Payments\Plan
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.8.0
 */

namespace SimplePay\Pro\Payments\Product;

use SimplePay\Core\Payments\Stripe_API;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Retrieves a Product.
 *
 * @since 3.8.0
 *
 * @param string|array $product Product ID or {
 *   Arguments used to retrieve a Product.
 *
 *   @type string $id Product ID.
 * }
 * @param array        $api_request_args {
 *   Additional request arguments to send to the Stripe API when making a request.
 *
 *   @type string $api_key API Secret Key to use.
 * }
 * @return \Stripe\Product
 * @throws \Stripe\Exception
 */
function retrieve( $product, $api_request_args = array() ) {
	if ( false === is_array( $product ) ) {
		$product_args = array(
			'id' => $product,
		);
	} else {
		$product_args = $product;
	}

	return Stripe_API::request(
		'Product',
		'retrieve',
		$product_args,
		$api_request_args
	);
}
