<?php
/**
 * Stripe Checkout: Session
 *
 * Pro-only functionality adjustments for Stripe Checkout Sessions.
 *
 * @package SimplePay\Pro\Payments\Stripe_Checkout\Plan
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.8.0
 */

namespace SimplePay\Pro\Payments\Stripe_Checkout\Session;

use SimplePay\Pro\Payment_Methods;
use SimplePay\Core\Payments\Stripe_Checkout;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Adds `payment_method_types` to Stripe Checkout Session.
 *
 * @since 3.8.0
 *
 * @param array                         $session_args Arguments used to create a PaymentIntent.
 * @param SimplePay\Core\Abstracts\Form $form Form instance.
 * @param array                         $form_data Form data generated by the client.
 * @param array                         $form_values Values of named fields in the payment form.
 * @param int                           $customer_id Stripe Customer ID.
 * @return array
 */
function add_payment_method_types( $session_args, $form, $form_data, $form_values, $customer_id ) {
	$payment_methods = Payment_Methods\get_form_payment_methods( $form );

	$payment_method_types = Stripe_Checkout\get_available_payment_method_types();
	$payment_method_types = array_intersect( $payment_method_types, array_keys( $payment_methods ) );

	$session_args['payment_method_types'] = array_values( $payment_method_types );

	return $session_args;
}
add_filter( 'simpay_get_session_args_from_payment_form_request', __NAMESPACE__ . '\\add_payment_method_types', 10, 5 );
