<?php
/**
 * Form Custom Fields: Payment Method
 *
 * Named `card` so existing forms keep the default
 * card field enabled.
 *
 * @package SimplePay\Core\Utils
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.8.0
 */

namespace SimplePay\Pro\Admin\Metaboxes\Views\Custom_Fields;

use function SimplePay\Pro\Payment_Methods\get_payment_methods;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post;

$counter = absint( $counter );
?>

<tr class="simpay-panel-field">
	<th>
		<label for="<?php echo 'simpay-card-label-' . $counter; ?>"><?php esc_html_e( 'Label', 'simple-pay' ); ?></label>
	</th>
	<td>
		<?php

		simpay_print_field(
			array(
				'type'        => 'standard',
				'subtype'     => 'text',
				'name'        => '_simpay_custom_field[card][' . $counter . '][label]',
				'id'          => 'simpay-card-label-' . $counter,
				'value'       => isset( $field['label'] ) ? $field['label'] : 'Payment Method',
				'class'       => array(
					'simpay-field-text',
					'simpay-label-input',
				),
				'attributes'  => array(
					'data-field-key' => $counter,
				),
				'description' => simpay_form_field_label_description(),
			)
		);

		?>
	</td>
</tr>

<?php
// Retrieve saved Payment Methods for the given context.
$context         = 'stripe-elements';
$payment_methods = simpay_get_saved_meta( $post->ID, '_payment_methods', array() );

if ( empty( $payment_methods ) ) {
	$payment_methods = array(
		'card' => array(
			'id' => 'card',
		),
	);
} else {
	$payment_methods = isset( $payment_methods[ $context ] )
		? $payment_methods[ $context ]
		: array();
}

// Retrieve available Payment Methods for the given context.
$available_payment_methods   = get_payment_methods();
$payment_methods_with_config = array(
	'card',
	'ach-debit',
);

include SIMPLE_PAY_INC . 'pro/admin/metaboxes/views/partials/payment-methods.php';
?>

<div
	title="<?php esc_attr_e( 'Configure Card', 'simple-pay' ); ?>"
	id="simpay-payment-method-configure-card"
	style="display: none;"
>
	<p class="simpay-payment-method-option">
		<label for="<?php echo 'simpay-card-postal_code-' . $counter; ?>">
			<?php esc_html_e( 'Hide Postal Code', 'simple-pay' ); ?>
			<?php
			simpay_print_field(
				array(
					'type'       => 'checkbox',
					'name'       => '_simpay_custom_field[card][' . $counter . '][postal_code]',
					'id'         => 'simpay-card-postal_code-' . $counter,
					'value'      => isset( $field['postal_code'] ) ? $field['postal_code'] : '',
					'attributes' => array(
						'data-field-key' => $counter,
					),
				)
			);
			?>
		</label>
	</p>

	<p class="simpay-payment-method-close">
		<button class="button button-primary update"><?php esc_html_e( 'Update', 'simple-pay' ); ?></button>
	</p>
</div>

<?php
$plaid_mode = true === simpay_is_test_mode()
	? 'sandbox'
	: 'production';
?>

<div
	title="<?php esc_attr_e( 'Configure ACH (via Plaid)', 'simple-pay' ); ?>"
	id="simpay-payment-method-configure-ach-debit"
	style="display: none;"
>
	<p style="margin: 0;">
		<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 685.7 349.9" style="width: 40%; margin: -15px;">
			<path fill="#111" d="M335.1 172.3h-7.7v-17.5h7c8.5 0 12.7 2.9 12.7 8.8-.1 5.8-4.1 8.7-12 8.7m21.5-28.8c-4.5-3.7-12.2-5.6-23-5.6H309v74.9h18.3v-23.5h8.2c10 0 17.3-2.2 21.9-6.5 5.2-4.9 7.9-11.3 7.9-19.4 0-8.4-2.9-15.1-8.7-19.9m40.1-5.6h-19.1v74.9h41.2v-17h-22.1v-57.9zm59.3 48.8l7.9-25.6 7.7 25.6H456zm.2-48.8l-30 74.9h20.6l3.9-10.9h26.1l3.6 10.9h20.8l-29.8-74.9h-15.2zm54.5 74.9h19.1v-74.9h-19.1v74.9zm62.7-17h-8.2v-41h8.3c5.8 0 10.3 1.8 13.5 5.4 3.1 3.6 4.7 8.7 4.7 15.4 0 13.5-6.1 20.2-18.3 20.2m30.5-43.9c-2.5-3.6-5.6-6.5-9.1-8.7-5.8-3.6-13.6-5.4-23.6-5.4H546v74.9h29.4c10.6 0 19.2-3.4 25.6-10.3s9.7-16 9.7-27.4c.1-9-2.2-16.7-6.8-23.1M259 259l16-62.4-21.6-21.6 21.6-21.7-16-62.4-62.4-16L175 96.6 153.3 75 90.9 91l-16 62.4L96.6 175l-21.7 21.7 16 62.4 62.4 16 21.7-21.7 21.6 21.6 62.4-16zm-71.7-18.1l20.6-20.6 26.2 26.2-32.8 8.4-14-14zm-33-99l20.6-20.6 20.6 20.6-20.6 20.6-20.6-20.6zm8.3 33L142 195.5l-20.6-20.6 20.6-20.6 20.6 20.6zm45.3-20.6l20.6 20.6-20.6 20.6-20.6-20.6 20.6-20.6zm-12.3 53.6L175 228.5l-20.6-20.6 20.6-20.6 20.6 20.6zm-47.1 47l-32.8-8.4 26.2-26.2 20.6 20.6-14 14zM109 187.3l20.6 20.6-26.2 26.2-8.4-32.8 14-14zm-5.7-71.6l26.2 26.2-20.5 20.7-14-14 8.3-32.9zm59.3-6.7L142 129.6l-26.2-26.2 32.8-8.4 14 14zm38.7-14.1l32.8 8.4-26.2 26.2-20.6-20.5 14-14.1zm39.6 67.7L220.3 142l26.2-26.2 8.4 32.8-14 14zm5.6 71.6L220.3 208l20.6-20.6 14 14-8.4 32.8z"/>
		</svg>
	</p>

	<p>
		<strong>
		<?php
		echo wp_kses(
			sprintf(
				__( '%1$sPlaid%2$s provides the quickest way to collect and verify your customer\'s banking information.', 'simple-pay' ),
				'<a href="https://plaid.com/" target="_blank" rel="noopener noreferrer">',
				'</a>'
			),
			array(
				'a' => array(
					'href'   => true,
					'target' => true,
					'rel'    => true,
				),
			)
		);
		?>
		</strong>
	</p>

	<p>
		<a href="https://dashboard.plaid.com/team/integrations" class="button button-primary button-large" target="_blank" rel="noopener noreferrer">
			<?php esc_html_e( 'Connect Plaid to Stripe', 'simple-pay' ); ?>
		</a>
	</p>

	<hr style="margin-bottom: 1rem;" />

	<p>
		<?php
		echo wp_kses(
			sprintf(
				/** Translators: %1$s Opening anchor tag, do not translate. %2$s Closing anchor tag, do not translate. */
				__( 'Retrieve your Client ID, Public Key, and Secret Keys from your %1$sPlaid account%2$s.', 'simple-pay' ),
				'<a href="https://dashboard.plaid.com/team/keys" target="_blank" rel="noopener noreferrer">',
				'</a>'
			),
			array(
				'code' => true,
				'a'    => array(
					'href'   => true,
					'target' => true,
					'rel'    => true,
				),
			)
		);
		?>
	</p>

	<p class="simpay-payment-method-option">
		<label for="<?php echo esc_attr( 'simpay-payment-methods-' . $counter . '-ach-debit-client-id' ); ?>">
			<?php esc_html_e( 'Plaid Client ID', 'simple-pay' ); ?>
		</label>
		<?php
		simpay_print_field(
			array(
				'type'    => 'standard',
				'subtype' => 'text',
				'name'    => '_simpay_payment_methods[' . $context . '][ach-debit][client_id]',
				'id'      => 'simpay-payment-methods-' . $counter . '-ach-debit-client-id',
				'value'   => isset( $payment_methods['ach-debit']['client_id'] )
					? $payment_methods['ach-debit']['client_id']
					: '',
			)
		);
		?>
	</p>

	<p class="simpay-payment-method-option">
		<label for="<?php echo esc_attr( 'simpay-payment-methods-' . $counter . '-ach-debit-secret-key' ); ?>">
			<?php esc_html_e( 'Plaid Secret', 'simple-pay' ); ?>
			<?php
			echo esc_html(
				'sandbox' === $plaid_mode
				? __( '(Sandbox)', 'simple-pay' )
				: __( '(Production)', 'simple-pay' )
			);
			?>
		</label>
		<?php
		simpay_print_field(
			array(
				'type'    => 'standard',
				'subtype' => 'password',
				'name'    => '_simpay_payment_methods[' . $context . '][ach-debit][secret_key][' . $plaid_mode . ']',
				'id'      => 'simpay-payment-methods-' . $counter . '-ach-debit-secret-key',
				'value'   => isset( $payment_methods['ach-debit']['secret_key'][ $plaid_mode ] )
					? $payment_methods['ach-debit']['secret_key'][ $plaid_mode ]
					: '',
			)
		);
		?>
	</p>

	<p class="simpay-payment-method-close">
		<button class="button button-primary update"><?php esc_html_e( 'Update', 'simple-pay' ); ?></button>
	</p>
</div>
