<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Do intval on counter here so we don't have to run it each time we use it below. Saves some function calls.
$counter = absint( $counter );
?>

<tr class="simpay-panel-field">
	<th>
		<label for="simpay-custom-amount-label"><?php esc_html_e( 'Label', 'simple-pay' ); ?></label>
	</th>
	<td>
		<?php
		simpay_print_field(
			array(
				'type'        => 'standard',
				'subtype'     => 'text',
				'name'        => '_custom_amount_label',
				'id'          => 'simpay-custom-amount-label',
				'value'       => isset( $field['label'] ) ? $field['label'] : 'Custom Amount',
				'class'       => array(
					'simpay-field-text',
					'simpay-label-input',
				),
				'attributes'  => array(
					'data-field-key' => $counter,
				),
				'description' => simpay_form_field_label_description(),
			)
		);
		?>

		<div class="notice inline notice-info">
			<p><?php esc_html_e( 'This where the "Custom Amount" field input will be displayed on the payment form.', 'simple-pay' ); ?></p>

			<p>
			<?php
			printf(
				wp_kses(
					__( '<a href="%1$s" class="%2$s" data-show-tab="%3$s">See "Payment Options"</a> to adjust custom amount settings.', 'simple-pay' ),
					array(
						'a' => array(
							'href'          => array(),
							'class'         => array(),
							'data-show-tab' => array(),
						),
					)
				),
				'#',
				'simpay-tab-link',
				'simpay-payment_options'
			);
			?>
			</p>
		</div>
	</td>
</tr>
