<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Do intval on counter here so we don't have to run it each time we use it below. Saves some function calls.
$counter = absint( $counter );

?>

<tr class="simpay-panel-field">
	<th>
		<label for="simpay-plan-select-form-field-label"><?php esc_html_e( 'Label', 'simple-pay' ); ?></label>
	</th>
	<td>
		<?php
		simpay_print_field(
			array(
				'type'        => 'standard',
				'subtype'     => 'text',
				'name'        => '_plan_select_form_field_label',
				'id'          => 'simpay-plan-select-form-field-label',
				'value'       => isset( $field['label'] ) ? $field['label'] : 'Choose a Plan',
				'class'       => array(
					'simpay-field-text',
					'simpay-label-input',
				),
				'attributes'  => array(
					'data-field-key' => $counter,
				),
				'description' => simpay_form_field_label_description(),
			)
		);
		?>
	</td>
</tr>

<tr class="simpay-panel-field">
	<td colspan="2">
		<div class="notice inline notice-info" style="margin-top: 16px;">
			<p><?php esc_html_e( 'This where the "Subscription Plan Selector" field will be displayed on the payment form. If "Custom Amount" is enabled within the plan selection it will also be displayed here.', 'simple-pay' ); ?><p>
			<p>
				<?php
				printf(
					wp_kses(
						__( '<a href="%1$s" class="%2$s" data-show-tab="%3$s">See "Subscription Options"</a> to adjust subscription settings.', 'simple-pay' ),
						array(
							'a' => array(
								'href'          => array(),
								'class'         => array(),
								'data-show-tab' => array(),
							),
						)
					),
					'#',
					'simpay-tab-link',
					'simpay-subscription_options'
				);
				?>
			</p>
		</div>
	</td>
</tr>
