<?php
/**
 * Simple Pay: Edit form display.
 *
 * @package SimplePay\Pro\Post_Types\Simple_Pay\Edit_Form
 * @copyright Copyright (c) 2020, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.8.0
 */

namespace SimplePay\Pro\Post_Types\Simple_Pay\Edit_Form;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Adds "Form Display Options" tab to Payment Form settings tabs.
 *
 * @since 3.8.0
 *
 * @param array $tabs Payment Form settings tabs.
 * @return array
 */
function add_settings_tab( $tabs ) {
	$tab_info = array(
		'label'  => esc_html__( 'Form Display Options', 'simple-pay' ),
		'target' => 'form-display-options-settings-panel',
		'class'  => array(),
		'icon'   => '',
	);

	$tabs = simpay_add_to_array_after(
		'form_display_options',
		$tab_info,
		'payment_options',
		$tabs
	);

	return $tabs;
}
add_filter( 'simpay_form_settings_meta_tabs_li', __NAMESPACE__ . '\\add_settings_tab' );

// Outputs "Company Name" and "Item Description" in "Form Display Options"
add_action(
	'simpay_admin_after_form_display_options_rows',
	'SimplePay\\Core\\Post_Types\\Simple_Pay\\Edit_Form\\add_company_info'
);

/**
 * Adds "Form Display Options" Payment Form settings tab content.
 *
 * @since 3.8.0
 *
 * @param int $post_id Current Payment Form ID.
 */
function add_display_options( $post_id ) {
	?>

<table>
	<tbody class="simpay-panel-section">

		<?php
		/**
		 * Allow extra setting rows to be added at the bottom of the table.
		 *
		 * @since 3.4.0
		 *
		 * @param int $form_id Current Payment Form ID.
		 */
		do_action( 'simpay_admin_before_form_display_options_rows', $post_id );
		?>

		<tr class="simpay-panel-field">
			<th>
				<label for="_form_display_type">
					<?php esc_html_e( 'Form Display Type', 'simple-pay' ); ?>
				</label>
			</th>
			<td>
				<?php
				$form_display_type = simpay_get_saved_meta( $post_id, '_form_display_type', 'embedded' );

				simpay_print_field(
					array(
						'type'    => 'radio',
						'name'    => '_form_display_type',
						'id'      => '_form_display_type',
						'value'   => $form_display_type,
						'class'   => array(
							'simpay-field-text',
							'simpay-multi-toggle',
						),
						'options' => array(
							'embedded'        => esc_html__( 'Embedded', 'simple-pay' ),
							'overlay'         => esc_html__( 'Overlay', 'simple-pay' ),
							'stripe_checkout' => esc_html__( 'Stripe Checkout', 'simple-pay' ),
						),
						'inline'  => 'inline',
					)
				);
				?>
				<p class="description simpay-show-if" data-if="_form_display_type" data-is="stripe_checkout">
					<?php
					printf(
						wp_kses(
							/* translators: %1$s URL to Stripe Checkout settings, %2$s Link clas, %3$s Tab to show */
							__( 'Configure your Stripe Checkout form in the <a href="%1$s" class="%2$s" data-show-tab="%3$s">Stripe Checkout Display</a> options.', 'simple-pay' ),
							array(
								'a' => array(
									'href'          => array(),
									'class'         => array(),
									'data-show-tab' => array(),
								),
							)
						),
						'#',
						'simpay-tab-link',
						'simpay-stripe_checkout'
					);
					?>
				</p>
			</td>
		</tr>

		<?php
		/**
		 * Allow extra setting rows to be added at the bottom of the table.
		 *
		 * @since 3.4.0
		 *
		 * @param int $form_id Current Payment Form ID.
		 */
		do_action( 'simpay_admin_after_form_display_options_rows', $post_id );
		?>

	</tbody>
</table>

	<?php
	echo simpay_docs_link( __( 'Help docs for Form Display Options', 'simple-pay' ), 'form-display-options', 'form-settings' );
}
add_action( 'simpay_form_settings_display_options_panel', __NAMESPACE__ . '\\add_display_options' );
